<?php 
$INC_DIR = $_SERVER['DOCUMENT_ROOT']."/gluco/diet/app/";
include $INC_DIR."src/common.php";

$mobile_detect = new Mobile_Detect;	
if ($mobile_detect->isMobile() && !$mobile_detect->isTablet()) {
  $url = $configs->mobile_path."?".$_SERVER['QUERY_STRING'];
  header("Location: $url");
}
$customer_details=get_customer_details($configs);
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title><?=$configs->page_title?></title>
<link rel="icon" type="image/png" href="assets/brand/favicon.png">
<!------css link---------->
<link rel="stylesheet" type="text/css" href="assets_lander/css/style.css">
<link rel="stylesheet" type="text/css" href="assets_lander/desktop/css/style.css">
<link rel="stylesheet" type="text/css" href="assets_lander/desktop/css/slick.css">

<script type="text/javascript">
	function getDate(days) {  
	var dayNames = new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");    
	var monthNames = new Array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");    
	var now = new Date();   
	now.setDate(now.getDate() + days);   
	var nowString =  monthNames[now.getMonth()] + " " + now.getDate() + ", " + now.getFullYear();   
	document.write(nowString); 
		}
</script>
<style>
        .has-error{
            border: 2px solid #ff5e45 !important;
            background-image: url('assets_lander/images/icon-validation-bad.png') !important;
            background-position: right center !important;
            background-repeat: no-repeat !important;
            background-size: 30px !important;
        }
        .no-error{
            border: 2px solid #6abd6a !important;
            background-image: url('assets_lander/images/icon-validation-good.png') !important;
            background-position: right center !important;
            background-repeat: no-repeat !important;
            background-size: 30px !important;
        }
		
		
		.modal .button {
	margin: 31px auto 15px;
	font-size: 25px;
	display: inline-block;
	padding: 0 25px;
	height: 50px;
	line-height: 50px!important
}

.modal .button:hover {
	color: #fff;
	background: #f60
}

.modal footer {
	text-align: center
}
.modal {
	display: none;
	vertical-align: middle;
	position: relative;
	z-index: 2;
	overflow: visible;
	max-width: 900px;
	box-sizing: border-box;
	width: 90%;
	padding: 34px 40px 40px;
	position: relative;
	border-radius: 10px;
	-webkit-box-shadow: 0 15px 50px 0 rgba(0,0,0,.15);
	-moz-box-shadow: 0 15px 50px 0 rgba(0,0,0,.15);
	-o-box-shadow: 0 15px 50px 0 rgba(0,0,0,.15);
	box-shadow: 0 15px 50px 0 rgba(0,0,0,.15);
	background: #fff;
	text-align: left
}

.modal p {
	margin-top: 0
}

.modal br {
	height: 0;
	line-height: 0
}

.modal a.close-modal {
	position: absolute;
	top: -12.5px;
	right: -12.5px;
	display: block;
	width: 30px;
	height: 30px;
	text-indent: -9999px;
	background-size: contain;
	background-repeat: no-repeat;
	background-position: center center;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAA8CAYAAAA6/NlyAAAAAXNSR0IArs4c6QAAA3hJREFUaAXlm8+K00Acx7MiCIJH/yw+gA9g25O49SL4AO3Bp1jw5NvktC+wF88qevK4BU97EmzxUBCEolK/n5gp3W6TTJPfpNPNF37MNsl85/vN/DaTmU6PknC4K+pniqeKJ3k8UnkvDxXJzzy+q/yaxxeVHxW/FNHjgRSeKt4rFoplzaAuHHDBGR2eS9G54reirsmienDCTRt7xwsp+KAoEmt9nLaGitZxrBbPFNaGfPloGw2t4JVamSt8xYW6Dg1oCYo3Yv+rCGViV160oMkcd8SYKnYV1Nb1aEOjCe6L5ZOiLfF120EjWhuBu3YIZt1NQmujnk5F4MgOpURzLfAwOBSTmzp3fpDxuI/pabxpqOoz2r2HLAb0GMbZKlNV5/Hg9XJypguryA7lPF5KMdTZQzHjqxNPhWhzIuAruOl1eNqKEx1tSh5rfbxdw7mOxCq4qS68ZTjKS1YVvilu559vWvFHhh4rZrdyZ69Vmpgdj8fJbDZLJpNJ0uv1cnr/gjrUhQMuI+ANjyuwftQ0bbL6Erp0mM/ny8Fg4M3LtdRxgMtKl3jwmIHVxYXChFy94/Rmpa/pTbNUhstKV+4Rr8lLQ9KlUvJKLyG8yvQ2s9SBy1Jb7jV5a0yapfF6apaZLjLLcWtd4sNrmJUMHyM+1xibTjH82Zh01TNlhsrOhdKTe00uAzZQmN6+KW+sDa/JD2PSVQ873m29yf+1Q9VDzfEYlHi1G5LKBBWZbtEsHbFwb1oYDwr1ZiF/2bnCSg1OBE/pfr9/bWx26UxJL3ONPISOLKUvQza0LZUxSKyjpdTGa/vDEr25rddbMM0Q3O6Lx3rqFvU+x6UrRKQY7tyrZecmD9FODy8uLizTmilwNj0kraNcAJhOp5aGVwsAGD5VmJBrWWbJSgWT9zrzWepQF47RaGSiKfeGx6Szi3gzmX/HHbihwBser4B9UJYpFBNX4R6vTn3VQnez0SymnrHQMsRYGTr1dSk34ljRqS/EMd2pLQ8YBp3a1PLfcqCpo8gtHkZFHKkTX6fs3MY0blKnth66rKCnU0VRGu37ONrQaA4eZDFtWAu2fXj9zjFkxTBOo8F7t926gTp/83Kyzzcy2kZD6xiqxTYnHLRFm3vHiRSwNSjkz3hoIzo8lCKWUlg/YtGs7tObunDAZfpDLbfEI15zsEIY3U/x/gHHc/G1zltnAgAAAABJRU5ErkJggg==)
}

.modal-spinner {
	display: none;
	position: fixed;
	top: 50%;
	left: 50%;
	transform: translateY(-50%) translateX(-50%);
	padding: 12px 16px;
	border-radius: 5px;
	background-color: #111;
	height: 20px
}

.modal-spinner>div {
	border-radius: 100px;
	background-color: #fff;
	height: 20px;
	width: 2px;
	margin: 0 1px;
	display: inline-block;
	-webkit-animation: sk-stretchdelay 1.2s infinite ease-in-out;
	animation: sk-stretchdelay 1.2s infinite ease-in-out
}

.modal-spinner .rect2 {
	-webkit-animation-delay: -1.1s;
	animation-delay: -1.1s
}

.modal-spinner .rect3 {
	-webkit-animation-delay: -1s;
	animation-delay: -1s
}

.modal-spinner .rect4 {
	-webkit-animation-delay: -.9s;
	animation-delay: -.9s
}
.modal h1 {
	font-size: 36px;
	margin-top: 0;
	margin-bottom: 10px;
	color: #313131
}

.modal h3,.modal h4 {
	font-weight: 700;
	padding: 0 0 15px;
	margin: 0;
	line-height: normal;
	color: #313131;
	font-size: 18px
}

.modal ol li,.modal ul li {
	line-height: normal
}

.modal p {
	padding: 0 0 17px;
	color: #313131;
	line-height: normal
}

.modal {
	font-size: 14px;
	height: auto!important;
	line-height: 20px;
	color: #313131;
	-webkit-overflow-scrolling: touch
}

@media(max-width:767px) {
	.modal {
		max-width: 100%;
		padding: 30px 20px
	}

	.modal h1 {
		font-size: 30px;
		line-height: normal
	}

	.blocker {
		padding: 20px 0
	}
}
#app_common_modal, #error_handler_overlay {
	position: fixed;
	top: 0;
	left: 0;
	padding: 0;
	margin: 0;
	width: 100%;
	height: 100%;
	z-index: 2147483647;
	background: #333;
	background: rgba(255,255,255,.8);
	display: none;
	overflow-x: hidden;
	-webkit-overflow-scrolling: touch;
}

.app_modal_body {
	margin: 100px auto;
	min-width: inherit;
	width: 95%;
	min-height: 400px;
	padding: 2.5%;
	background-color: #fff;
	background-clip: padding-box;
	border: 1px solid #999;
	border: 1px solid rgba(0,0,0,.2);
	border-radius: 0;
	-webkit-box-shadow: 0 3px 9px rgb(0 0 0 / 50%);
	box-shadow: 0 3px 9px rgb(0 0 0 / 50%);
	font-size: 14px;
	line-height: 1.42857143;
	color: #333;
	position: relative;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	-ms-box-sizing: border-box;
}

#app_common_modal .app_modal_body, #error_handler_overlay .error_handler_body {
	max-width: 600px;
	-webkit-background-clip: padding-box;
	font-family: Verdana,Geneva,sans-serif;
	box-sizing: border-box;
	outline: 0;
}

#app_common_modal .app_modal_body iframe {
    min-height: 400px;
    width: 100%;
    border: 1px solid #d5d6ef;
}

#app_common_modal_close, #error_handler_overlay_close {
    position: absolute;
    right: -10px;
    top: -10px;
    color: #FFF;
    background-color: #333;
    border: 2px solid #FFF;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    text-align: center;
    cursor: pointer;
    text-decoration: none;
    font-weight: 700;
    line-height: 30px;
    padding: 0;
    margin: 0;
}

#error_handler_overlay .error_handler_body {
    margin: 100px auto;
    width: 95%;
    padding: 20px;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #999;
    border: 1px solid rgba(0,0,0,.2);
    border-radius: 0;
    -webkit-box-shadow: 0 3px 9px rgb(0 0 0 / 50%);
    box-shadow: 0 3px 9px rgb(0 0 0 / 50%);
    font-size: 14px;
    line-height: 1.42857143;
    color: #333;
    position: relative;
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
}

#app_common_modal_close, #error_handler_overlay_close {
    position: absolute;
    right: -10px;
    top: -10px;
    color: #FFF;
    background-color: #333;
    border: 2px solid #FFF;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    text-align: center;
    cursor: pointer;
    text-decoration: none;
    font-weight: 700;
    line-height: 30px;
    padding: 0;
    margin: 0;
}
		</style>
</head>

<body>

<div class="overflow">

<div class="top-caption">
	<div class="container">
    	<p><img src="assets_lander/desktop/images/clock.png" width="14" height="17" alt=""> <span>Hurry! Claim</span> Up To <span>2 Free Bottles</span> With Your Order Today!</p>
    </div>
</div>

<div class="bnr-sec">
	<div class="container">
    	<div class="bnr-left">
        	<img src="assets_lander/brand/logo3.png" class="top-logo" width="382" height="31" alt="logo">
        	<p class="bnr-sub-hdg">Manage Your Blood Sugar & </p>
            <p class="bnr-hdg">Melt Away Excess<br>Fat, Faster <img src="assets_lander/desktop/images/wl-img.png" width="305" height="52" alt=""></p>
            
            <div class="bnr-strip">
            	<img src="assets_lander/desktop/images/bnr-strp-img.png" width="68" height="68" class="bnr-strp-img">
            	<div class="bnr-stp-top">The Safer, Cheaper & Alternative To Ozempic</div>
                <ul class="bnr-strp-list">
                	<li><img src="assets_lander/desktop/images/strip-cross.png" width="14" height="14"> No Shots</li>
                    <li><img src="assets_lander/desktop/images/strip-cross.png" width="14" height="14"> No Prescriptions</li>
                    <li><img src="assets_lander/desktop/images/strip-cross.png" width="14" height="14"> No Side Effects</li>
                </ul>
            </div>
            
            <p class="bnr-para"><?=$configs->step1_name?> tells your body to burn more calories, <br>fires up fat loss & control your cravings to help you <br>slay your health & fitness goals!</p>
            
            <ul class="bnr-list">
            	<li>Maintains Normal Blood Sugar Levels</li>
                <li>Optimizes Insulin Sensitivity</li>
                <li>Actives "Metabolic Master Switch"</li>
                <li>Burns Fat & Blocks New Fat Formation</li>
                <li>Suppresses Appetite & Curbs Cravings</li>
            </ul>
            
            <div class="revw-bx">
            	<img src="assets_lander/desktop/images/revw-user.png" width="65" height="65" class="revw-user">
                <img src="assets_lander/desktop/images/revw-star.png" width="63" height="11" class="revw-star">
                <p class="revw-txt">Only using 2 weeks, I have dropped from 130-145 down to 108 - 80!!! This is amazing.</p>
                <p class="revw-nm">Sharon Thoele</p>
            </div>
		</div>  
         
        <img src="assets_lander/brand/prod.png" width="304" height="584" class="bnr-product">  
        
        <div class="frm-rgt" id="frm-top">
        	<img src="assets_lander/desktop/images/frm-seals.png" width="219" height="69" class="frm-seals">
            
        	<div class="frmBox">
            	<img src="assets_lander/desktop/images/frm-arw.png" width="94" height="444" class="frm-arrw">
                
                <div class="frmtxt">
                    <p class="frm-txt1">Offer Valid Till <span><script type="text/javascript">getDate(0);</script></span></p>
                </div>
                
                <div class="frm-hd">
                    <p>Order Now & Claim Your</p>
                    <span>Free Bottles</span>
                </div>
                
                 <form  name="prospect_form1" class="kform form123" id="theForm" action="/gluco/diet/app/src/ajax.php" onSubmit="return validate_optin_form()" method="post" accept-charset="utf-8" enctype="application/x-www-form-urlencoded;charset=utf-8">
                    <input type="hidden" name="device" value="desktop">
                    <input type="hidden" name="pgtag" value="dindex">
                    <input type="hidden" name="pk" value="5">
                    <input type="hidden" name="shippingCountry" value="US">
                    <?php
                        foreach($customer_details['affiliate_details'] as $key => $value) {
                            echo "<input type='hidden' name='".$key."' value='".$value."'>";
                        }
                    ?>
                    <div class="frm-sec">
                        <div class="code-bx">
                            <p class="code-bx-txt1 fl">Discount Code:<br><img src="assets_lander/desktop/images/frm-tk.png" width="12" height="12"> <span>Activated</span></p>
                            <p class="code-bx-txt2 fr">FREEBOTTLE</p>
                        </div>
                    
                        <input type="text" name="firstName" id='fields_fname' class="inp-fld" placeholder="First Name*">
                        <input type="text" name="lastName" id='fields_lname' class="inp-fld" placeholder="Last Name*">
                        <input type="text" name="shippingAddress1" id="fields_address1" class="inp-fld" placeholder="Address*">
                        <input type="text" name="shippingZip" id="fields_zip" class="inp-fld" placeholder="Zip Code*">
                        <input type="text" name="shippingCity" id="fields_city" class="inp-fld" placeholder="City*">
                        <select name="shippingState" id="fields_state" class="inp-fld">
                            <option value="" onClick="">Select State</option>
                                    <option value="AL">Alabama (AL)</option>
                                    <option value="AK">Alaska (AK)</option>
                                    <option value="AS">American Samoa (AS)</option>
                                    <option value="AZ">Arizona (AZ)</option>
                                    <option value="AR">Arkansas (AR)</option>
                                    <option value="AE">Armed Forces (AE)</option>
                                    <option value="AA">Armed Forces Americas (AA)</option>
                                    <option value="AP">Armed Forces Pacific (AP)</option>
                                    <option value="CA">California (CA)</option>
                                    <option value="CO">Colorado (CO)</option>
                                    <option value="CT">Connecticut (CT)</option>
                                    <option value="DE">Delaware (DE)</option>
                                    <option value="DC">District of Columbia (DC)</option>
                                    <option value="FM">Federated States of Micronesia (FM)</option>
                                    <option value="FL">Florida (FL)</option>
                                    <option value="GA">Georgia (GA)</option>
                                    <option value="GU">Guam (GU)</option>
                                    <option value="HI">Hawaii (HI)</option>
                                    <option value="ID">Idaho (ID)</option>
                                    <option value="IL">Illinois (IL)</option>
                                    <option value="IN">Indiana (IN)</option>
                                    <option value="IA">Iowa (IA)</option>
                                    <option value="KS">Kansas (KS)</option>
                                    <option value="KY">Kentucky (KY)</option>
                                    <option value="LA">Louisiana (LA)</option>
                                    <option value="ME">Maine (ME)</option>
                                    <option value="MD">Maryland (MD)</option>
                                    <option value="MA">Massachusetts (MA)</option>
                                    <option value="MI">Michigan (MI)</option>
                                    <option value="MN">Minnesota (MN)</option>
                                    <option value="MS">Mississippi (MS)</option>
                                    <option value="MO">Missouri (MO)</option>
                                    <option value="MT">Montana (MT)</option>
                                    <option value="NE">Nebraska (NE)</option>
                                    <option value="NV">Nevada (NV)</option>
                                    <option value="NH">New Hampshire (NH)</option>
                                    <option value="NJ">New Jersey (NJ)</option>
                                    <option value="NM">New Mexico (NM)</option>
                                    <option value="NY">New York (NY)</option>
                                    <option value="NC">North Carolina (NC)</option>
                                    <option value="ND">North Dakota (ND)</option>
                                    <option value="MP">Northern Mariana Islands (MP)</option>
                                    <option value="OH">Ohio (OH)</option>
                                    <option value="OK">Oklahoma (OK)</option>
                                    <option value="OR">Oregon (OR)</option>
                                    <option value="PA">Pennsylvania (PA)</option>
                                    <option value="MH">Republic of Marshall Islands (MH)</option>
                                    <option value="RI">Rhode Island (RI)</option>
                                    <option value="SC">South Carolina (SC)</option>
                                    <option value="SD">South Dakota (SD)</option>
                                    <option value="TN">Tennessee (TN)</option>
                                    <option value="TX">Texas (TX)</option>
                                    <option value="UT">Utah (UT)</option>
                                    <option value="VT">Vermont (VT)</option>
                                    <option value="VI">Virgin Islands of the U.S. (VI)</option>
                                    <option value="VA">Virginia (VA)</option>
                                    <option value="WA">Washington (WA)</option>
                                    <option value="WV">West Virginia (WV)</option>
                                    <option value="WI">Wisconsin (WI)</option>
                                    <option value="WY">Wyoming (WY)</option>				
                        </select>
                        
                        <input type="text" id="fields_email" name="email" class="inp-fld" placeholder="Email Address*">
                        <input type="text" id="fields_phone" name="phone" class="inp-fld" placeholder="Phone Number*">
                        
                        <div class="clearall"></div>
                        <div class="frmbtn-bx">
                            <button class="frm-btn pulse">Unlock Offer</button>
                            <div class="frm-btnTxt">
                                <p class="frm-btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                                <p class="frm-btnText2"><img src="assets_lander/images/shape.png" class="frm-hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
                            </div>
                        </div>
                
                        
                        <img src="assets_lander/desktop/images/frm-secur-log.png" width="192" height="25" class="frm-secur-log">
                    </div>
                    
                    <div class="secure-bg"><img src="assets_lander/desktop/images/lock-icn.png" width="10" height="14"> Secure 256 Bit Encrypted Connection</div>
                </form>
            </div>
        </div>
	</div>
</div>

<div class="sec-1">
	<div class="container">
    	<p class="s1-hdg">Blood Sugar Imbalance Is<br>Leading Cause Of Weight Gain</p>
        <p class="common-para">Blood sugar imbalance leads to weight gain. <?=$configs->brand?> stabilizes blood sugar for lasting weight loss.</p>
		
        <ul class="s1-point">
        	<li>
                <img src="assets_lander/desktop/images/s1-arw-icon.png" width="23" height="47" class="s1-lst-arw">
                <img src="assets_lander/desktop/images/s1-bnr-img1.jpg" width="363" height="233" class="s1-list-img">
                <h3>Insulin Production<br>Leads To Fat Storage</h3>
                <p class="common-para s1-list-para">Insulin regulates blood sugar and stores excess glucose as fat. <?=$configs->brand?> controls insulin, reducing fat storage for weight loss.</p> 
            </li>
            
            <li>
                <img src="assets_lander/desktop/images/s1-arw-icon.png" width="23" height="47" class="s1-lst-arw">
                <img src="assets_lander/desktop/images/s1-bnr-img2.jpg" width="363" height="233" class="s1-list-img">
                <h3>Low Sugar Levels<br>Leads To Craving</h3>
                <p class="common-para s1-list-para">Low sugar levels trigger food cravings as your body seeks a quick energy boost. <?=$configs->brand?> reduces cravings for better weight control.</p>  
            </li>
            
            <li>
                <img src="assets_lander/desktop/images/s1-arw-icon.png" width="23" height="47" class="s1-lst-arw">
                <img src="assets_lander/desktop/images/s1-bnr-img3.jpg" width="363" height="233" class="s1-list-img">
                <h3>Interrupts Body's<br>Satiety Signals</h3>
                <p class="common-para s1-list-para"><?=$configs->brand?> Interrupts Satiety Signals for Effective Weight Management.</p>  
            </li>
        </ul>
        
        <div class="s1-btmBox">
        	<div class="s1-prodbox">
            	<img src="assets_lander/brand/prod.png" width="304" height="584" class="s1-prod1 fl">
                <img src="assets_lander/brand/prod.png" width="304" height="584" class="s1-prod2 fr">
                <img src="assets_lander/desktop/images/s1-pnt-img.png" width="50" height="121" class="s1-pnt-img">
            </div>
            <p class="s1-btm-txt"> <h1>MELT FAT <span>FAST!</span></h1>
                        <h2>WITHOUT DIET OR EXERCISE</h2>
                        <h3>Powerful New Formula Triggers Fat-Burning!</h3></p>
        </div>
    </div>
</div>

<div class="sec-2">
	<div class="container">
    	<div class="s2-cont">
        	<p class="commn-hdg commn-hdg-lft">Introducing <?=$configs->brand?><br><span>Fat Burner Formula</span></p>
            <p class="common-para">Introducing <?=$configs->brand?>, your ultimate solution for achieving weight loss and sugar balance in one powerful formula. We've combined the latest scientific advancements to create a cutting-edge fat burner that not only helps you shed those extra pounds but also supports healthy blood sugar levels.</p>
        <p class="comn-txt"><?=$configs->brand?>'s innovative formula is designed to maximize fat burning while promoting optimal blood sugar management. It's the perfect choice for those looking to harness the dual benefits of weight loss and sugar balance, all in a single, easy-to-use supplement.</p>
        </div>
        
        <div class="s2-prodbox">
        	<img src="assets_lander/brand/prod.png" width="304" height="584" class="s2-prod">
            <ul class="s2-prod-list">
            	<li>
                	<img src="assets_lander/desktop/images/s2-lst-icn1.png" width="24" height="22">
                    <div class="s2-prd-cont">
                    	<p>Total Servings</p>
                        <h4>30</h4>
                    </div>
                </li>
                <li>
                	<img src="assets_lander/desktop/images/s2-lst-icn2.png" width="24" height="22">
                    <div class="s2-prd-cont">
                    	<p>Strength</p>
                        <h4>306MG</h4>
                    </div>
                </li>
                <li>
                	<img src="assets_lander/desktop/images/s2-lst-icn3.png" width="24" height="22">
                    <div class="s2-prd-cont">
                    	<p>Dose</p>
                        <h4>1 Tablet</h4>
                    </div>
                </li>
            </ul>
            <img src="assets_lander/desktop/images/meter-img.png" width="532" height="155" class="meter-img">
        </div>
        
        <div class="s2-box" style="margin-top:0px;">
        	<div class="s2-box-header">
            	<p>Why Does <?=$configs->brand?> Have<br>Experts & Media Buzzing </p>
            </div>
            
            <div class="s2-box-cont">
            	<div class="cont-left">
                    <p class="common-para white top-0">A recent study published in the Diabetes, Obesity, and Metabolism Journal found that <?=$configs->brand?> is a game-changer for those seeking to lose weight while effectively managing their blood sugar. This breakthrough formula supports the body in burning fat for energy, resulting in significant weight loss and improved blood sugar control. <?=$configs->brand?>'s dual benefits make it a powerful choice for those aiming to achieve both their weight loss and blood sugar management goals.</p>

                    <div class="clearall"></div>
                    <div class="btn-bx">
                        <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
                        <div class="btnTxt white">
                            <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                            <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
                        </div>
                    </div>
                    
                </div>
                
                <img src="assets_lander/desktop/images/media-img.png" width="574" height="360" class="media-img">
            </div>
        </div>
        
	</div>
</div>

<div class="sec-3">
	<div class="container">
    	<div class="s3-prodbox">
        	<img src="assets_lander/desktop/images/s3-bnr-img.jpg" width="656" height="679" class="s3-bnr-img">
            <img src="assets_lander/brand/prod.png" width="304" height="584" class="s3-prod">
            <img src="assets_lander/desktop/images/s3-arw.png" width="117" height="221" class="s3-arw">
        </div>	
        
    	<div class="s3-cont">
        	<p class="commn-hdg commn-hdg-lft">Get Ready To Fuel<br><span>Natural Weight Loss</span></p>
            <ul class="s3-list">
            	<li>
                    <img src="assets_lander/desktop/images/s3-icn1.png" width="74" height="74">
                    <h4 class="s3-list-head">Supports Healthy Weight Loss</h4>
                    <p class="common-para s3-list-para"><?=$configs->brand?> aids in weight loss by promoting fat burning and supporting a healthier metabolism.</p>
                </li>
                <li>
                    <img src="assets_lander/desktop/images/s3-icn2.png" width="74" height="74">
                    <h4 class="s3-list-head">Maintains Normal Blood Sugar Levels</h4>
                    <p class="common-para s3-list-para">It helps regulate and stabilize blood sugar levels for better overall health.</p>
                </li>
                <li>
                    <img src="assets_lander/desktop/images/s3-icn3.png" width="74" height="74">
                    <h4 class="s3-list-head">Burns Fat & Blocks New Fat Formation</h4>
                    <p class="common-para s3-list-para"><?=$configs->brand?> facilitates fat breakdown while preventing the formation of new fat cells</p>
                </li>
                <li>
                    <img src="assets_lander/desktop/images/s3-icn4.png" width="74" height="74">
                    <h4 class="s3-list-head">Suppresses Appetite & Curbs Cravings</h4>
                    <p class="common-para s3-list-para">It reduces feelings of hunger and cravings for better appetite control.</p>
                </li>
                <li>
                    <img src="assets_lander/desktop/images/s3-icn5.png" width="74" height="74">
                    <h4 class="s3-list-head">Boost Digestion & Energy</h4>
                    <p class="common-para s3-list-para"><?=$configs->brand?> improves digestion and increases energy levels, helping you feel more energetic throughout the day.</p>
                </li>
            </ul>
            <div class="clearall"></div>
            <div class="btn-bx">
                <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
                <div class="btnTxt">
                    <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                    <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
                </div>
            </div>
        </div>
	</div>
</div>

<div class="sec-4">
	<div class="container">
    	<div class="s4-cont">
        	<p class="commn-hdg commn-hdg-lft">The Science Behind<br><span>#1 Natural Weight Loss</span></p>
            <p class="common-para">The science behind <?=$configs->brand?> enables you to optimize insulin sensitivity and promote efficient glucose utilization. Not only does this aid in managing blood sugar, but it also encourages healthy weight loss, making <?=$configs->brand?> your go-to choice for overall well-being.</p>
        </div>
	</div>
    <div class="clearall"></div>
    
    <div class="s4-container">
    	<div class="s4-block">
            <div class="s4-left">
                <ul class="s4-list">
                    <li>
                        <p class="stps-txt">1</p>
                        <h4 class="s4-list-head">Cellular Fat Targeting</h4>
                        <p class="common-para s4-list-para"><?=$configs->brand?> precisely targets fat cells, aiding weight loss through breakdown.</p>
                    </li>
                    <li>
                        <p class="stps-txt">2</p>
                        <h4 class="s4-list-head"><?=$configs->brand?>'s Fat Cell Consumption</h4>
                        <p class="common-para s4-list-para"><?=$configs->brand?> actively consumes fat within cells, contributing to effective weight management.</p>
                    </li>
                    <li>
                        <p class="stps-txt">3</p>
                        <h4 class="s4-list-head"><?=$configs->brand?>'s Pounds Elimination Process</h4>
                        <p class="common-para s4-list-para"><?=$configs->brand?> targets fat cells, aiding weight loss, and promotes healthy blood sugar management.</p>
                    </li>
                </ul>
                <div class="clearall"></div>
                <div class="btn-bx">
                    <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
                    <div class="btnTxt">
                        <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                        <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
                    </div>
                </div>
            </div>
            
            <div class="s4-rgt">
                <img src="assets_lander/desktop/images/s4-doctor-img.jpg" width="511" height="437" class="s4-doctor-img">
                <img src="assets_lander/desktop/images/s4-seal.png" width="136" height="135" class="s4-seal">
                <div class="s4-scnbox">
                    <p class="s4-scn-head">SCIENTIFICALLY PROVEN TO MELT FAT NATURALLY</p>
                    <ul class="s4-scn-list">
                        <li>
                            <img src="assets_lander/desktop/images/s4-scn-img1.png" width="135" height="137">
                            <p>Adhering to<br>Fat Cells</p>
                        </li>
                        <li>
                            <img src="assets_lander/desktop/images/s4-scn-img2.png" width="135" height="137">
                            <p>Devouring<br>Fat Cells</p>
                        </li>
                        <li>
                            <img src="assets_lander/desktop/images/s4-scn-img3.png" width="135" height="137">
                            <p>Eliminates <br>Pounds</p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="sec-5">
	<div class="container">
		<p class="commn-hdg">Powerful Ingredients<br><span>Helps To Balance Your Weight Loss</span></p>
        <p class="common-para">At <?=$configs->brand?>, our powerful blend of ingredients has been carefully crafted to play a pivotal role in your weight loss journey by effectively balancing key aspects of your health and well-being.</p> 
        
        <div class="s5-block">
        	<div class="ingbox">
            	<img src="assets_lander/desktop/images/ingredient-img.png" width="498" height="499" class="ingredient-img">
                <img src="assets_lander/desktop/images/ing-txt2.png" width="184" height="192" class="animated-img">
            </div>
        
        	<ul class="s5-list fl">
            	<li>
                	<h4>Berberine HCI <img src="assets_lander/desktop/images/s5-lst-ln1.png" width="384" height="47"></h4>
                    <p class="common-para">Aids weight loss by enhancing metabolism and supporting healthy blood sugar regulation.</p>
                </li>	
                <li>
                	<h4>Bitter Melon Extract <img src="assets_lander/desktop/images/s5-lst-ln2.png" width="307" height="1">	</h4>
                    <p class="common-para">Assists in weight loss by improving glucose utilization and insulin sensitivity, helping maintain stable blood sugar levels.</p>
                </li>
                <li>
                	<h4>Banaba Leaf Extract <img src="assets_lander/desktop/images/s5-lst-ln3.png" width="398" height="34"></h4>
                    <p class="common-para">Supports weight loss by promoting the breakdown of carbohydrates and assisting in healthy blood sugar control.</p>
                </li>
            </ul>
            
            <ul class="s5-list fr">
            	<li>
                	<h4>Cinnamon Extract <img src="assets_lander/desktop/images/s5-lst-ln4.png" width="384" height="47"></h4>
                    <p class="common-para">Enhances weight loss by improving insulin sensitivity and reducing post-meal blood sugar spikes.</p>
                </li>	
                <li>
                	<h4>Inulin <img src="assets_lander/desktop/images/s5-lst-ln2.png" width="307" height="1">	</h4>
                    <p class="common-para">Promotes weight loss by increasing feelings of fullness and stabilizing blood sugar, reducing overeating.</p>
                </li>
                <li>
                	<img src="assets_lander/desktop/images/s5-seals.png" width="326" height="95" class="s5-seals">
                </li>
            </ul>
        </div>  
        
        <div class="clearall"></div>
        <div class="btn-bx">
            <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
            <div class="btnTxt">
                <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
            </div>
        </div>
	</div>
</div>

<div class="sec-6">
	<div class="container">
		<p class="commn-hdg">Comparision<br><span>Our Vs Other Brand</span></p>
        <p class="common-para"><?=$configs->brand?> outshines the competition with a science-backed formula inspired by top brands, providing effective natural solutions for blood sugar control and weight management.</p> 
             
        <div class="comp-chart">
            <div class="chart-col-1">
                <ul>
                	<li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>All Natural Ingredients</p></li>
                    <li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>Reaction Time</p></li>
                    <li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>Absorption Rate</p></li> 
                    <li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>Ease of Dosage</p></li>
                    <li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>Non-Habit Forming</p></li>
                    <li><img src="assets_lander/desktop/images/comp-icn.png" width="13" height="13"><p>Side Effects</p></li>
                </ul>
            </div>
            <div class="chart-col-2">
            	<div class="chart-prod-top">
                	<img src="assets_lander/brand/prod.png" width="304" height="584" class="chart-prod1">
                    <p><?=$configs->brand?></p>
                </div>
            	<ul>
                	<li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>Yes</p></li>
                	<li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>3-5 Minutes</p></li>
                    <li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>65%</p></li>
                    <li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>Standard</p></li>
                    <li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>Yes</p></li>
                    <li><img src="assets_lander/desktop/images/tick.png" width="33" height="33"><p>No</p></li>
                </ul>
            </div>
            <div class="chart-col-2 chart-col-3">
            	<div class="chart-prod-top">
                	<img src="assets_lander/desktop/images/chart-prod2.png" width="100" height="54" class="chart-prod2">
                    <p>Ozempic<br>Injection</p>
                </div>
            	<ul>
                	<li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>No</p></li>
                	<li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>4-5 Minutes</p></li>
                    <li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>15%</p></li>
                    <li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>Variable</p></li>
                    <li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>No</p></li>
                    <li><img src="assets_lander/desktop/images/cross.png" width="33" height="33"><p>Yes</p></li>
                </ul>
            </div>
        </div>
        
        <div class="mnybkBox">
        	<img src="assets_lander/desktop/images/mnybk-seal1.png" width="248" height="249" class="mnybk-seal">
            <div class="mnybk-cont">
            	<p class="mnybk-heading">No Prescription Required!</p>
                <p class="common-para mnybk-para mb-tp">With <?=$configs->brand?>, there's no need for a prescription. Achieve better health on your terms with our natural solution.</p>
                <p class="common-para mnybk-para"><?=$configs->brand?> offers convenience and effectiveness without the prescription hassle, helping you take control of your wellness journey.</p>
            </div>
        </div>
        
        <div class="clearall"></div>
        <div class="btn-bx">
            <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
            <div class="btnTxt">
                <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
            </div>
        </div>  
	</div>
</div>

<div class="sec-7">
	<div class="container">
		<p class="commn-hdg">Customer Testimonials<br><span>What People Says About Us</span></p>
        
        <div class="rev-slider">
            <div class="rev-bx">
                <div class="rev-lft-slide">
                    <img src="assets_lander/desktop/images/rev-slide-img1.jpg" width="463" height="420">
                </div>
                <div class="rev-rgt-slide">
                    <img src="assets_lander/desktop/images/star.png" width="97" height="16" class="testi-star">
                    <div class="clearall"></div>
                    <p class="slide-para"><?=$configs->brand?> transformed my life. Lost 20 lbs, and my blood sugar levels are steady. Highly recommended!</p>
                    <div class="sldr-sepr"></div>
                    <p class="slide-nm">Jenny M.<br><small><img src="assets_lander/desktop/images/very-tik.png" class="very-tik" width="15" height="15">Verified Buyer</small></p>
                </div>
            </div>
            
            <div class="rev-bx">
                <div class="rev-lft-slide">
                    <img src="assets_lander/desktop/images/rev-slide-img2.jpg" width="463" height="420">
                </div>
                <div class="rev-rgt-slide">
                    <img src="assets_lander/desktop/images/star.png" width="97" height="16" class="testi-star">
                    <div class="clearall"></div>
                    <p class="slide-para">Effective for weight loss and blood sugar control. Feeling healthier and more energetic. A game-changer!</p>
                    <div class="sldr-sepr"></div>
                    <p class="slide-nm">John M.<br><small><img src="assets_lander/desktop/images/very-tik.png" class="very-tik" width="15" height="15">Verified Buyer</small></p>
                </div>
            </div>
            
            <div class="rev-bx">
                <div class="rev-lft-slide">
                    <img src="assets_lander/desktop/images/rev-slide-img3.jpg" width="463" height="420">
                </div>
                <div class="rev-rgt-slide">
                    <img src="assets_lander/desktop/images/star.png" width="97" height="16" class="testi-star">
                    <div class="clearall"></div>
                    <p class="slide-para"><?=$configs->brand?> helped me shed 15 pounds and maintain stable blood sugar levels. Thrilled with the results!</p>
                    <div class="sldr-sepr"></div>
                    <p class="slide-nm">Meghan H.<br><small><img src="assets_lander/desktop/images/very-tik.png" class="very-tik" width="15" height="15">Verified Buyer</small></p>
                </div>
            </div>
            
            <div class="rev-bx">
                <div class="rev-lft-slide">
                    <img src="assets_lander/desktop/images/rev-slide-img4.jpg" width="463" height="420">
                </div>
                <div class="rev-rgt-slide">
                    <img src="assets_lander/desktop/images/star.png" width="97" height="16" class="testi-star">
                    <div class="clearall"></div>
                    <p class="slide-para"><?=$configs->brand?> is a lifesaver. Dropped 18 lbs while keeping my blood sugar in check. My go-to supplement!</p>
                    <div class="sldr-sepr"></div>
                    <p class="slide-nm">Emily G.<br><small><img src="assets_lander/desktop/images/very-tik.png" class="very-tik" width="15" height="15">Verified Buyer</small></p>
                </div>
            </div>
            
            <div class="rev-bx">
                <div class="rev-lft-slide">
                    <img src="assets_lander/desktop/images/rev-slide-img5.jpg" width="463" height="420">
                </div>
                <div class="rev-rgt-slide">
                    <img src="assets_lander/desktop/images/star.png" width="97" height="16" class="testi-star">
                    <div class="clearall"></div>
                    <p class="slide-para">Effective for both weight loss and blood sugar management. This product truly delivers.</p>
                    <div class="sldr-sepr"></div>
                    <p class="slide-nm">Josh B.<br><small><img src="assets_lander/desktop/images/very-tik.png" class="very-tik" width="15" height="15">Verified Buyer</small></p>
                </div>
            </div>
        </div>
        
        <div class="clearall"></div>
        <div class="btn-bx">
            <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
            <div class="btnTxt">
                <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
            </div>
        </div>  
	</div>
</div>

<div class="sec-8">
	<div class="container">
		<p class="commn-hdg">Frequently Asked Questions<br><span>We’ve All The Answers</span></p>
        
        <div class="faq-container" style="overflow:hidden;">
            <div class="up-slide-dwn active">
                <div class="accordion acdn-heading" id="hd-one">How do I take <?=$configs->brand?> for the best results?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para">For optimal results, take one <?=$configs->brand?> capsule with a glass of water before your largest meal of the day. Follow the recommended dosage on the label.</p>
                </div>
            </div>
            
            <div class="up-slide-dwn">
                <div class="accordion acdn-heading">How soon can I expect to see results with <?=$configs->brand?>?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para">Results may vary, but some users report improvements in weight loss and blood sugar management within a few weeks of consistent use.</p>
                </div>
            </div>
            
      		<div class="up-slide-dwn">
                <div class="accordion acdn-heading"> Is <?=$configs->brand?> safe for long-term use?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para"><?=$configs->brand?> is designed for long-term use. It's formulated to support sustainable weight management and blood sugar control.</p>
                </div>
            </div>
            
            <div class="up-slide-dwn">
                <div class="accordion acdn-heading">What sets <?=$configs->brand?> apart from other similar products on the market?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para"><?=$configs->brand?> stands out due to its dual action on weight loss and blood sugar management, backed by scientific research and positive user experiences.</p>
                </div>
            </div>
            
            <div class="up-slide-dwn">
                <div class="accordion acdn-heading">How long does it typically take for <?=$configs->brand?> to be delivered?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para">Delivery times may vary based on your location and chosen shipping method. You can expect an estimated delivery time during the checkout process.</p>
                </div>
            </div>
            
            <div class="up-slide-dwn">
                <div class="accordion acdn-heading">How should I store <?=$configs->brand?>?</div>
                <div class="acdn-content">
                    <p class="common-para acdn-para">Store <?=$configs->brand?> in a cool, dry place, away from direct sunlight and moisture. Keep it out of reach of children.</p>
                </div>
            </div>
    	</div>
        
       	<div class="clearall"></div>
        <div class="btn-bx">
            <a href="javascript:bookmarkscroll.scrollTo('frm-top');" class="comn-btn"> Claim Free Bottles <img src="assets_lander/desktop/images/btn-arw-img.png" width="55" height="37" class="btn-arw-img hand-tadda"></a>
            <div class="btnTxt">
                <p class="btnText1"><span>Sale:</span> is Live for 24 Hrs.</p>
                <p class="btnText2"><img src="assets_lander/desktop/images/shape.png" class="hourglass" width="12" height="18"> Stock: Only <span>126</span> Units Left!</p>
            </div>
        </div>  
	</div>
</div>

<div class="footer">
    <div class="container">
            <p class="ftr-txt"> 
                <a href="javascript:void(0);" onClick="openNewWindow('disclosures/terms.php','modal');">Terms & Conditions</a> <span>| </span>
                <a href="javascript:void(0);" onClick="openNewWindow('disclosures/privacy.php','modal');">Privacy Policy</a> | 
                <a href="javascript:void(0);" onClick="openNewWindow('disclosures/wireless.php','modal');">Wireless Policy</a></p>
        <p class="ftr-txt">Copyright <script type="text/javascript">var year = new Date();document.write(year.getFullYear());</script> &copy; All Rights Reserved</p>
        <p class="ftr-txt2">This product should be used only as directed on the label. It should not be used if you are pregnant or nursing. Consult with a physician before use if you have a serious medical condition or use prescription medications. A Doctor's advice should be sought before using this and any supplemental dietary product. All trademarks and copyrights are property of their respective owners and are not affiliated with nor do they endorse this product. By using this site, you agree to follow the Privacy Policy and all Terms & Conditions printed on this site. Void Where Prohibited by Law. By submitting information on this page, you give consent for us to send promotions via email and SMS to your phone number provided. Opt out and other detailed information is provided in the Privacy Policy.</p>
    </div>
</div> 

</div>
<!------Script---------->
<!------Script---------->
<script type="text/javascript" src="assets_lander/desktop/js/jquery-3.6.0.min.js"></script> 
<script type="text/javascript" src="assets_lander/desktop/js/jquery.accordion.js"></script>
<script type="text/javascript" src="assets_lander/desktop/js/bookmarkscroll.js"></script>
<script type="text/javascript" src="assets_lander/desktop/js/slick.js"></script>
<script type="text/javascript" src="assets_lander/js/jquery.mask.min.js"></script>


<div class="popup-loading-wrapper" style="display:none;">
    <div class="popup">
        <figure class="product-image"></figure>
        <p>Reserving Your Bottle Of</p>
        <h2>Blood Booster</h2>
        <img src="assets_lander/images/icon-loading.png" alt="" class="loading-image">
    </div>
</div>

<p id="loading-indicator" style="display:none;">Processing...</p>
<p id="crm-response-container" style="display:none;">Limelight messages will appear here...</p>



<script type="text/javascript">

	$('.rev-slider').slick({
		dots: false,
		arrows:true,
		speed: 300,
		slidesToShow: 1,
		slidesToScroll: 1,
		infinite: true,
	});
	
	$('.accordion').accordion({
		defaultOpen: 'hd-one',
		speed: 'slow'
	});

    function isScrolledIntoView(elem) {
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();
        
        var elemTop = $(elem).offset().top;
        var elemBottom = elemTop + $(elem).height();
        
        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    }
    
    $(window).scroll(function(){
    
        if (isScrolledIntoView('.frm-arrw') === true) {
           $('.frm-arrw').addClass('frm-animate-arrow');
        }    
    });

</script>

<script type="text/javascript">
    $(document).ready(function () {
        $('.single-item').slick({
            arrows: false,
            dots: true,
            autoplay: true,
            autoplaySpeed: 2600,
        });
    });
</script>
<script type="text/javascript" src="assets_lander/js/jquery.autocomplete.min.js"></script>
<script type="text/javascript" src="assets_lander/js/custom.js"></script>
<!-- <script>
    var smtKey = '83089717372519727';
    var smtAuto = 0;
    var smtVerify = 0;
    var smartUrl = "https://us-autocomplete-pro.api.smartystreets.com/lookup?key=" + smtKey + "&prefer_geolocation=city";
    var lastAddress1 = '';
    var lastAddress2 = '';

    if (typeof smtKey !== "undefined" && smtKey != '') {
        function submitAddress2() {
            if (lastAddress1 == '') {
                lastAddress1 = $('input[name="fields_address1"]').val();
                lastAddress1.replace('"', '');
            }
            lastAddress2 = $('input[name="fields_address2"]').val();
            lastAddress2.replace('"', '');
            var combAddr = lastAddress1 + ', ' + lastAddress2;
            $('input[name="fields_address1"]').val(combAddr);
            $('#app_common_modal').remove();
            $('#theForm').trigger('submit');
            return false;
        }

        var utils2 = (function () {
            return {
                escapeRegExChars: function (value) {
                    return value.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&");
                },
                createNode: function (containerClass) {
                    var div = document.createElement('div');
                    div.className = containerClass;
                    div.style.position = 'absolute';
                    div.style.display = 'none';
                    return div;
                }
            };
        }());

        $(document).ready(function (ee) {
            if (typeof smtAuto !== "undefined" && smtAuto == 1) {
                $('#fields_address1').autocomplete({
                    serviceUrl: smartUrl,
                    paramName: "search",
                    ajaxSettings: {},
                    minChars: 2,
                    deferRequestBy: 400,
                    transformResult: function (response) {
                        if (typeof response === "undefined") {
                            return {
                                "suggestions": []
                            };
                        } else if (typeof response == "string") {
                            respJson = JSON.parse(response);
                        } else {
                            respJson = response;
                        }
                        if (!(respJson) || typeof respJson.suggestions === "undefined" || respJson.suggestions == null) {
                            return {
                                "suggestions": []
                            };
                        }

                        return {
                            suggestions: $.map(respJson.suggestions, function (dataItem) {
                                return {
                                    value: dataItem.street_line + (dataItem.secondary != '' && dataItem.entries == 1 ? (', ' + dataItem.secondary) : ''),
                                    data: dataItem
                                };
                            })
                        };
                    },
                    formatResult: function (suggestion, currentValue) {
                        if (typeof suggestion.data === "undefined") {
                            return "";
                        } else {
                            if (!currentValue) {
                                return suggestion.data.text;
                            }

                            var pattern = '(' + utils2.escapeRegExChars(currentValue) + ')';

                            var addrfull = suggestion.data.street_line + (
                                suggestion.data.secondary != '' ? (
                                    suggestion.data.entries > 1 ? (', ' + suggestion.data.secondary + ' (' + suggestion.data.entries + ' entries)') : (', ' + suggestion.data.secondary)
                                ) : '') + ', ' + suggestion.data.city + ' ' + suggestion.data.state + ' ' + suggestion.data.zipcode;

                            return addrfull
                                .replace(new RegExp(pattern, 'gi'), '<strong>$1<\/strong>')
                                .replace(/&/g, '&amp;')
                                .replace(/</g, '&lt;')
                                .replace(/>/g, '&gt;')
                                .replace(/"/g, '&quot;')
                                .replace(/&lt;(\/?strong)&gt;/g, '<$1>');
                        }
                    },
                    onSelect: function (suggestion) {
                        if ($('#fields_city').length == 1 && (suggestion.data.city)) {
                            $('#fields_city').val(suggestion.data.city);
                        }
                        if ($('#fields_state').length == 1 && (suggestion.data.state)) {
                            $('#fields_state').val(suggestion.data.state);
                        }
                        if ($('#fields_zip').length == 1 && (suggestion.data.zipcode)) {
                            $('#fields_zip').val(suggestion.data.zipcode);
                        }

                    }
                });
            }
        });

    }


    $('form.form123').find('#fields_email').on('change keyup', function () {
        var emailReg2 = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        if (!emailReg2.test($('#fields_email').val())) {
            $(this).addClass('has-error');
            $(this).removeClass('no-error');
        }
    });

    $('form.form123').find('#fields_zip').on('change keyup', function () {
        var zip = $('#fields_zip').val();
        if ((zip.length) < 5) {
            $(this).addClass('has-error');
            $(this).removeClass('no-error');
        }
    });

    $('form#theForm').find('input, select, textarea').on('change keyup', function () {
        $('form#theForm').find('input, select').each(function () {
            if ($(this).val() == '') {
                $(this).addClass('has-error');
                $(this).removeClass('no-error');
            } else {
                $(this).removeClass('has-error');
                $(this).addClass('no-error');
            }
        });
    });


    function validate_optin_form() {
			
        ShowExitPopup = false;
        internal = 1;
        isExit = false;

        var errors = new Array();
        var phonefilter = /^([0-9\-\+\(\)]{8,22})+$/;
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        //var is_terms_condtion_cheked = $('#agree_terms').prop('checked');
        //console.log($('#fields_fname').val().replace(/^\s+|\s+$/g,"")==''));

        $("input").removeClass("has-error");

      		var firstNameValue = $('#fields_fname').val().replace(/^\s+|\s+$/g, "");

		if (firstNameValue == '') {
			errors.push('Please enter your first name');
			$('#fields_fname').addClass("has-error");
		} else if (/[\d]/.test(firstNameValue)) {
			errors.push('First name should not contain numbers');
			$('#fields_fname').addClass("has-error");
		}
		var lastNameValue = $('#fields_lname').val().replace(/^\s+|\s+$/g, "");

		if (lastNameValue == '') {
			errors.push('Please enter your last name');
			$('#fields_lname').addClass("has-error");
		} else if (/[\d]/.test(lastNameValue)) {
			errors.push('Last name should not contain numbers');
			$('#fields_lname').addClass("has-error");
		}
        if ($('#fields_address1').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please select your address');
            $('#fields_address1').addClass("has-error");
        }
        if ($('#fields_city').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please enter your city');
            $('#fields_city').addClass("has-error");
        }
        if ($('#fields_state').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please enter your State');
            $('#fields_state').addClass("has-error");
        }
        if ($('#fields_zip').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please enter your Zip Code');
            $('#fields_zip').addClass("has-error");
        }
        if ($('#fields_phone').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please enter your phone number');
            $('#fields_phone').addClass("has-error");
        }
        if ($('#fields_email').val().replace(/^\s+|\s+$/g, "") == '') {
            errors.push('Please enter your email address');
            $('#fields_email').addClass("has-error");
        } else if (!emailReg.test($('#fields_email').val())) {
            errors.push('Please enter valid email address');
            $('#fields_email').addClass("has-error");
        }

        /*if($('#agree_terms:checked').length == 0) {
        errors.push('Please accept our terms and condition');
        }*/


        if (typeof smtKey !== "undefined" && smtKey != '' && typeof smtVerify !== "undefined" && smtVerify == 1) {
            if (errors.length == 0) {
                var addr = $('input[name="fields_address1"]').val() + ', ' + $('input[name="fields_city"]').val() + ' ' + $('select[name="fields_state"]').val() + ' ' + $('input[name="fields_zip"]').val();
                var errmsg = "";
                var vcode = "";
                var apiUrl = "https://us-street.api.smartystreets.com/street-address"
                    + "?street=" + encodeURI(addr)
                    + "&key=" + smtKey;
                $.ajax({
                    url: apiUrl,
                    method: "get",
                    async: false,
                    beforeSend: function (xhr) {
                    }
                })
                    .done(function (resData) {
                        var errmsg = "";
                        if (!(resData) || !(resData[0]) || !(resData[0].analysis) || !(resData[0].analysis.dpv_match_code)) {
                            vcode = "";
                        } else {
                            vcode = resData[0].analysis.dpv_match_code;
                        }

                        if (vcode != '' && vcode != 'N' && vcode != 'D') {
                            if (typeof resData[0].delivery_line_1 !== "undefined" && resData[0].delivery_line_1 != "") {
                                $('input[name="fields_address1"]').val(resData[0].delivery_line_1);
                                lastAddress1 = $('input[name="fields_address1"]').val();
                            }

                            if (typeof resData[0].components !== "undefined") {
                                if (typeof resData[0].components.city_name !== "undefined" && resData[0].components.city_name != "") {
                                    $('input[name="fields_city"]').val(resData[0].components.city_name);
                                }
                                if (typeof resData[0].components.zipcode !== "undefined" && resData[0].components.zipcode != "") {
                                    $('input[name="fields_zip"]').val(resData[0].components.zipcode);
                                }
                                if (typeof resData[0].components.state_abbreviation !== "undefined" && resData[0].components.state_abbreviation != "") {
                                    $('select[name="fields_state"]').val(resData[0].components.state_abbreviation);
                                }
                            }

                        }
                    })
                    .fail(function () {
                    })
                    .always(function () {
                    });


                if (vcode == '') {
                    errors.push('Address could not be found');
                } else if (vcode == 'N') {
                    errors.push('Address does not seem to be deliverable');
                } else if (vcode == 'D') {

                    var html = '';
                    html += '<div id="app_common_modal">';
                    html += '<div class="app_modal_body" style="text-align:center;min-height:150px;"><a href="javascript:void(0);" id="app_common_modal_close">X</a>';

                    html += '<div>'
                        + '<form method="get" action="" onSubmit="return submitAddress2();">'
                        + '<h4>' + "Please enter your Apartment/Suite/Unit # to proceed" + '</h4>'
                        + '<input type="text" name="fields_address2" id="fields_address2" placeholder="" autocomplete="off" required style="width:80%;line-height:22px;margin:10px;padding:5px" maxlength="50" value="' + (lastAddress2 != '' ? lastAddress2 : '') + '" data-error-message="Please enter your address!" />'
                        + '<button type="submit" style="width:40%;height:30px;line-height:22px;cursor:pointer;">OK</button>'
                        + '</form>';
                    +'</div>';

                    html += '</div>';
                    html += '</div>';

                    if (!$('#app_common_modal').length) {
                        $('body').append(html);
                    }
                    $('#app_common_modal').fadeIn(500);
                    return false;

                }

            }
        }


        if (errors.length == 0) {
            $('.popup-loading-wrapper').show();
            $('#fields_phone').unmask();
            document.getElementById('theForm').submit();
            return false;
        } else {
            var li = '';
            $.each(errors, function (key, value) {
                li += '<li>' + value + '</li>';
            });

            var html = '';
            html += '<div id="error_handler_overlay">';
            html += '<div class="error_handler_body"><a href="javascript:void(0);" id="error_handler_overlay_close">X</a><ul>' + li + '</ul></div>';
            html += '</div>';

            $('body').append(html);

            $('#error_handler_overlay').fadeIn(500);
            return false;
        }
    }


    $(function () {
        $(window).keydown(function (e) {
            if (e.which === 27 && $('#error_handler_overlay').length) {
                $('#error_handler_overlay').remove();
            }
        });

        $(document).off('click', '#error_handler_overlay');
        $(document).on('click', '#error_handler_overlay', function () {
            $(this).remove();
        });

        $(document).off('click', '#error_handler_overlay_close');
        $(document).on('click', '#error_handler_overlay_close', function () {
            $('#error_handler_overlay').remove();
        });

        $(document).on('click', '#app_common_modal_close', function () {
            //     alert('close');
            $('#app_common_modal').remove();
        });
    });

</script>
<script>
    function onlyNumbers(e, type) {
        var keynum;
        var keychar;
        var numcheck;
        if (window.event) // IE
        {
            keynum = e.keyCode;
        } else if (e.which) // Netscape/Firefox/Opera
        {
            keynum = e.which;
        }
        keychar = String.fromCharCode(keynum);
        numcheck = /\d/;

        switch (keynum) {
            case 8:    //backspace
            case 9:    //tab
            case 35:   //end
            case 36:   //home
            case 37:   //left arrow
            case 38:   //right arrow
            case 39:   //insert
            case 45:   //delete
            case 46:   //0
            case 48:   //1
            case 49:   //2
            case 50:   //3
            case 51:   //4
            case 52:   //5
            case 54:   //6
            case 55:   //7
            case 56:   //8
            case 57:   //9
            case 96:   //0
            case 97:   //1
            case 98:   //2
            case 99:   //3
            case 100:  //4
            case 101:  //5
            case 102:  //6
            case 103:  //7
            case 104:  //8
            case 105:  //9
                result2 = true;
                break;
            case 109: // dash -
                if (type == 'phone') {
                    result2 = true;
                } else {
                    result2 = false;
                }
                break;
            default:
                result2 = numcheck.test(keychar);
                break;
        }

        return result2;
    }

    function openNewWindow(page_url, type, window_name, width, height, top, left, features) {
        if (!type) {
            type = 'popup';
        }

        if (!width) {
            width = 480;
        }

        if (!height) {
            height = 480;
        }

        if (!top) {
            top = 50;
        }

        if (!left) {
            left = 50;
        }

        if (!features) {
            features = 'resizable,scrollbars';
        }

        if (type == 'popup') {
            var settings = 'height=' + height + ',';
            settings += 'width=' + width + ',';
            settings += 'top=' + top + ',';
            settings += 'left=' + left + ',';
            settings += features;

            win = window.open(page_url, window_name, settings);
            win.window.focus();
        } else if (type == 'modal') {
            var html = '';
            html += '<div id="app_common_modal">';
            html += '<div class="app_modal_body"><a href="javascript:void(0);" id="app_common_modal_close">X</a><iframe src="' + page_url + '" frameborder="0"></iframe></div>';
            html += '</div>';

            if (!$('#app_common_modal').length) {

                $('body').append(html);
            }
            $('#app_common_modal').fadeIn();
        }

    }
</script> -->
</body>
</html>

