/* window.dataLayer = window.dataLayer || [];
var selectors = {
    shippingForm: '#shipping-mobile',
    qualifyForm: '#qualify',
    checkoutForm: '#checkout',
    firstName: 'input[name="firstName"]',
    lastName: 'input[name="lastName"]',
    phone: 'input[name="phone"]',
    email: 'input[name="email"]',
    address: 'input[name="address"]',
    country: '#id_country',
    state: '#id_state',
    city: 'input[name="city"]',
    zipCode: 'input[name="zipCode"]',
    loader: ".popup-loading-wrapper",
    billingForm: '.billing-form',
    cardNumber: 'input[name="cardNumber"]',
    cardExpMonth: '#cardExpMonth',
    cardExpYear: '#cardExpYear',
    cvv: 'input[name="cvv"]',
    paymentAsShipping: '#payment_as_shipping',
    formError: "#formError",
    package: '.package',
    sendButton: '.btn__send'
}
var rules = {
    expMonth: {
        required: true,
    },
    expYear: {
        required: true,
        CCExp: true,
    },
    cardNumber: {
        required: true,
        creditcard: true,
    },
    cvv: {
        required: true,
        digits: true,
        minlength: 3,
        maxlength: 4,
    },
    country: "required",
    state: "required",
    firstName: {
        latin: true,
        maxlength: 24,
        required: true,
    },
    lastName: {
        latin: true,
        maxlength: 24,
        required: true,
    },
    address: "required",
    city: "required",
    zipCode: {
        zipCodeValidator: true
    },
    phone: {
        phoneValidator: true
    },
    email: {
        required: true,
        email: true,
    },
};
var someText = {
    en: {
        CA: "Select Province",
        GB: "Select County",
        IE: "Select County",
        NZ: "Select Region",
        Default: "Select State",
    },
    es: {
        US: "Seleccione estado",
        Default: "Seleccione estado",
    },
    fr: {
        CA: "Sélectionnez la région",
        Default: "Sélectionnez la région",
    },
    de: {
        US: "Staat wählen",
        Default: "Wählen Bundesland",
    }
};
var errorText = {
    en: "Transaction was declined, please try another credit card",
    fr: "La transaction a été refusée, veuillez essayer une autre carte de crédit",
    es: "La transacción fue rechazada, intente con otra tarjeta de crédito",
    ru: "Транзакция была отклонена, попробуйте другую кредитную карту",
    de: "Die Transaktion wurde abgelehnt. Bitte versuchen Sie es mit einer anderen Kreditkarte"
};
function urlParam(name) {
    var results = new RegExp("[?&]" + name + "=([^&#]*)").exec(window.location.href);
    if (results == null) {
        return null;
    } else {
        return results[1] || 0;
    }
}
function getCurrentPath() {
    var arr = window.location.pathname.split("/");
    var page = arr.slice(0, -1);
    var name = page.join("/");
    return name;
}
function getCurrentPageName() {
    var arr = window.location.pathname.split("/");
    var page = arr[arr.length - 1];
    var name = page.split(".");
    return name[0];
}
function getPage(name) {
    var path = getCurrentPath();
    switch (name) {
    case 'confirmation':
        return path + "/confirmation.php";
    case 'checkout':
        return path + "/checkout.php";
    case 'declined':
        return path + "/declined.php";
    case 'qualify':
        return path + "/qualify.php";
    case 'choose':
        return path + "/choose.php";
    case 'shipping':
        return path + "/shipping.php";
    }
}

window.offer = {
    data: null,
    isStateLoaded: false,
    isLoading: false,
    country: null,
    phones: null,
    usingBilling: false,
    rules: rules,
    someText: someText,
    pricesProduct: null,
    upsaleList: null,
    products: null,
    errorText: errorText,
    listeners: [],
    loadState: function() {
        var that = this;
        var url = "/ajax/state";
        var uid = urlParam("uid");
        if (uid) {
            url += "?uid=" + uid;
        }
        that.isLoading = true;
        $.ajaxSetup({
            cache: false
        });
        $.get(url, function(res) {
            that.data = res.data;
            that.isStateLoaded = true;
            that.isLoading = false;
            that.country = window.country || res.data.geo.code || 'US';
            that.phones = res.data.templates.phone;
            that.pricesProduct = res.data.availableProducts;
            that.products = res.data.products;
            that.upsaleList = res.data.upsales;
            var segment = res.data.segment;
            var state = res.data.state;
            var shipping = res.data.profile.shipping;
            var t = res.data.query.hasOwnProperty('t') ? res.data.query['t'] : null;
            var segmentData = {
                segmentAff: segment.aff,
                segmentNet: segment.net,
                segmentSub: segment.sub,
                segmentPage: segment.page,
            };
            if (t) {
                segmentData['t'] = t;
            }
            window.dataLayer.push(segmentData);
            var r = urlParam("r");
            var isDirect = r === "direct";
            var page = getCurrentPageName();
            if (isDirect && state === "partial" && shipping.address.length && page === 'index') {
                window.location.pathname = getPage('order');
            } else if (state === "purchase" && page !== 'confirmation') {
                window.location.pathname = getPage('confirmation');
            } else if (state === "decline" && page !== 'declined') {
                window.location.pathname = getPage('declined');
            } else {
                for (var i = 0; i < that.listeners.length; i++) {
                    that.listeners[i].cb(res.data);
                }
            }
        });
    },

    getCheckoutPage: function() {
        return getPage('checkout')
    },
    getDeclinedPage: function() {
        return getPage('declined')
    },
    getShippingPage: function() {
        return getPage('shipping')
    },
    getQualifyPage: function() {
        return getPage('qualify')
    },
    getConfirmPage: function() {
        return getPage('confirmation')
    },
    getChoosePage: function() {
        return getPage('choose')
    },
    getCurrentPath: getCurrentPath,
    getUrlParam: urlParam,
    sendOrder: function(formData, cb) {
        var url = "/ajax/order";
        var uid = urlParam("uid");
        if (uid) {
            url = "/ajax/order" + "?uid=" + uid;
        }
        $.post(url, formData, function(res) {
            cb(res);
        });
    },
    getValidationRules: function(name) {
        if (rules[name]) {
            return rules[name];
        }
        return null;
    },
    setUsingBilling: function(flag) {
        this.usingBilling = flag;
    },
    getUsingBilling: function() {
        return this.usingBilling;
    },
    setValidationRule: function(name, rule) {
        this.rules[name] = rule;
    },
    getSelectors: function() {
        return selectors;
    },
    getCountryIsoCode: function() {
        return this.country;
    },
    getSomeText: function(lang, isoCode) {
        return this.someText[lang || "en"][this.someText[lang || "en"].hasOwnProperty(isoCode) ? isoCode : "Default"];
    },
    getErrorText: function(lang) {
        return this.errorText[lang || "en"];
    },
    changeGeo: function(phones) {
        $('.local-phone').html(phones);
    },
    getPrice: function() {
        var pricesProduct = this.pricesProduct
          , product = '.package';
        for (var i = 0; i < pricesProduct.length; i++) {
            $(product + (i + 1) + ' .price').html((window.currency || "$") + pricesProduct[i].price.toFixed(2))
            $(product + (i + 1) + ' .save-price').html((window.currency || "$") + pricesProduct[i].templates.save)
            $(product + (i + 1) + ' .retail-price').html((window.currency || "$") + pricesProduct[i].templates.retail)
            $(product + (i + 1) + ' .retail-price-full').html((window.currency || "$") + (pricesProduct[i].templates.retail * pricesProduct[i].quantity).toFixed(2));
            $(product + (i + 1) + ' .retail-price-short').html((window.currency || '$') + pricesProduct[i].templates.retail.split('.')[0]);
            $(product + (i + 1) + ' .full-price').html((window.currency || '$') + pricesProduct[i].fullprice.toFixed(2));
            $(product + (i + 1) + ' .price-int').attr('data-currency', pricesProduct[i].price.toFixed(2));
            $(product + (i + 1) + ' .save-price-int').attr('data-currency', pricesProduct[i].templates.save);
            $(product + (i + 1) + ' .retail-price-int').attr('data-currency', pricesProduct[i].templates.retail);
            $(product + (i + 1) + ' .full-price-int').attr('data-currency', pricesProduct[i].templates.retail);
        }
    },
    getPrivacy: function() {
        $('.product-name').html(this.data.templates.title);
    },
    getTerms: function(phone) {
        var products = this.products
          , upsaleList = this.upsaleList
          , productName = this.data.templates.title
          , upsalesStr = ""
          , packagesInfo = ""
          , shippingPrice = ""
          , num = 0;
        upsaleList.filter(function(upsale) {
            if (upsale.templates.title === "Expedited Shipping") {
                return false;
            }
            return true;
        }).map(function(upsale) {
            num = num + 1
            upsalesStr += "<br>" + "2.5." + num + " Additional Opt-in Product: " + upsale.templates.title + ", if purchased, will be shipped within 24 hours and arrive\n" + " within 5-7 business days. You are ordering a 30 day supply and will be charged" + " $" + upsale.price + " (+ free S&H) for the\n" + " product you receive. This purchase is backed by a 100% Money Back " + "Guarantee. If at some point you choose to\n" + " cancel this purchase, call customer service at " + phone + " anytime between 9am to 5pm MST Monday-Friday."
        });
        if (products.length >= 1 && products[2].quantity === 1) {
            shippingPrice = "(+ 9.95 S&H)"
        } else {
            shippingPrice = "(+ free S&H)"
        }
        packagesInfo += "<br>" + "2.1.1. The prices for the products are as follows: " + "$" + products[0].fullprice + " (+ free S&H) for the " + products[0].quantity + " bottle package (" + "$" + products[0].price + " bottle); " + "$" + products[1].fullprice + " (+ free S&H) for the " + products[1].quantity + " bottle package (" + "$" + products[1].price + " bottle); " + "$" + products[2].fullprice + " " + shippingPrice + " for the " + products[2].quantity + " bottle package " + "($" + products[2].price + " bottle).";
        $(".packagesInfo").html(packagesInfo);
        $(".upsalesList").html(upsalesStr);
        $(".product-name").html(productName);
    },
    getPhone: function() {
        var geoPhone, currentPhone, phone, iso_code = this.country, phones = this.phones;
        if (phones.indexOf(iso_code + ': ') >= 0) {
            geoPhone = phones.split(iso_code + ': ');
            currentPhone = geoPhone[1].split(/[A-Z]* / + ': ')
            currentPhone = currentPhone[0].split(', ');
            phone = currentPhone[0]
        } else if (phones.match(/[a-z]*[A-Z]+[a-z]* /)) {
            geoPhone = phones.split(': ');
            if (geoPhone.length === 1) {
                currentPhone = geoPhone[0].split(',');
            } else {
                currentPhone = geoPhone[1].split(',');
            }
            phone = currentPhone[0];
        }
        this.changeGeo(phone || phones);
        this.getTerms(phone || phones);
        $('.phone-line').html(phone || phones);
    },
}; */
